/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.net.URL;
import java.util.Hashtable;
import netscape.applet.AppletPeer;
import sun.awt.ObjectPeer;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.URLImageSource;
import sun.awt.windows.PaintEvent;
import sun.awt.windows.StandardGUIEvent;
import sun.awt.windows.WButtonPeer;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WCheckboxMenuItemPeer;
import sun.awt.windows.WCheckboxPeer;
import sun.awt.windows.WChoicePeer;
import sun.awt.windows.WDialogPeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WLabelPeer;
import sun.awt.windows.WListPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuItemPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WScrollbarPeer;
import sun.awt.windows.WTextAreaPeer;
import sun.awt.windows.WTextFieldPeer;
import sun.awt.windows.WWindowPeer;

class WToolkit
extends Toolkit
implements Runnable {
    boolean serverThread = true;
    boolean libraryLoaded = false;
    Thread callbackThread;
    static Hashtable imgHash = new Hashtable();
    static ColorModel screenmodel;

    Thread getCallbackThread() {
        return this.callbackThread;
    }

    public WToolkit() {
        new Thread(this, "AWT-Windows").start();
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            try {
                while (this.serverThread) {
                    this.wait(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                System.exit(1);
            }
        }
        if (this.libraryLoaded) {
            this.callbackThread = new Thread(this, "AWT-Callback");
            this.callbackThread.start();
        }
    }

    private native void init(Thread var1);

    public void run() {
        if (this.serverThread) {
            try {
                SecurityManager.enablePrivilege("UniversalLinkAccess");
                String string = System.getProperty("os.name");
                if (string.compareTo("16-bit Windows") == 0) {
                    System.loadLibrary("awt1640");
                } else {
                    System.loadLibrary("awt3240");
                }
                SecurityManager.revertPrivilege();
                this.init(Thread.currentThread());
                this.libraryLoaded = true;
                this.serverThread = false;
                this.eventLoop();
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.libraryLoaded = false;
                this.serverThread = false;
                return;
            }
        }
        this.callbackLoop();
    }

    native void callbackLoop();

    native void eventLoop();

    public native void notImplemented();

    protected ButtonPeer createButton(Button button) {
        return new WButtonPeer(button);
    }

    protected TextFieldPeer createTextField(TextField textField) {
        return new WTextFieldPeer(textField);
    }

    protected LabelPeer createLabel(Label label) {
        return new WLabelPeer(label);
    }

    protected ListPeer createList(List list) {
        return new WListPeer(list);
    }

    protected CheckboxPeer createCheckbox(Checkbox checkbox) {
        return new WCheckboxPeer(checkbox);
    }

    protected ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        return new WScrollbarPeer(scrollbar);
    }

    protected TextAreaPeer createTextArea(TextArea textArea) {
        return new WTextAreaPeer(textArea);
    }

    protected ChoicePeer createChoice(Choice choice) {
        return new WChoicePeer(choice);
    }

    protected FramePeer createFrame(Frame frame) {
        return new WFramePeer(frame);
    }

    protected CanvasPeer createCanvas(Canvas canvas) {
        return new WCanvasPeer(canvas);
    }

    protected PanelPeer createPanel(Panel panel) {
        return new WPanelPeer(panel);
    }

    protected WindowPeer createWindow(Window window) {
        return new WWindowPeer(window);
    }

    protected DialogPeer createDialog(Dialog dialog) {
        return new WDialogPeer(dialog);
    }

    protected FileDialogPeer createFileDialog(FileDialog fileDialog) {
        return new WFileDialogPeer(fileDialog);
    }

    protected MenuBarPeer createMenuBar(MenuBar menuBar) {
        return new WMenuBarPeer(menuBar);
    }

    protected MenuPeer createMenu(Menu menu) {
        return new WMenuPeer(menu);
    }

    protected MenuItemPeer createMenuItem(MenuItem menuItem) {
        return new WMenuItemPeer(menuItem);
    }

    protected CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        return new WCheckboxMenuItemPeer(checkboxMenuItem);
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        System.getSecurityManager().checkURLConnect(uRL);
        Image image = (Image)imgHash.get(uRL);
        if (image == null) {
            try {
                image = toolkit.createImage(new URLImageSource(uRL));
                imgHash.put(uRL, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        System.getSecurityManager().checkRead(string);
        Image image = (Image)imgHash.get(string);
        if (image == null) {
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgHash.put(string, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public Image getImage(String string) {
        return WToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return WToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n < 0) {
            n = -1;
        }
        if (n2 < 0) {
            n2 = -1;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep(n, n2);
        return imageRepresentation.prepare(imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        int n3;
        WImage wImage = (WImage)image;
        if (n == 0 || n2 == 0) {
            n3 = 32;
        } else {
            if (n < 0) {
                n = -1;
            }
            if (n2 < 0) {
                n2 = -1;
            }
            n3 = wImage.getImageRep(n, n2).check(imageObserver);
        }
        return wImage.check(imageObserver) | n3;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = WToolkit.makeColorModel();
        }
        return screenmodel;
    }

    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    public native int getScreenResolution();

    public native void sync();

    native int getScreenWidth();

    native int getScreenHeight();

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "Helvetica", "TimesRoman", "Courier", "Symbol"};
        return stringArray;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    void sendEvent(AppletPeer appletPeer, int n, ObjectPeer objectPeer) {
        appletPeer.sendEvent(new StandardGUIEvent(n, objectPeer));
    }

    void sendPaintEvent(AppletPeer appletPeer, ObjectPeer objectPeer, int n, int n2, int n3, int n4, int n5) {
        PaintEvent paintEvent = new PaintEvent(objectPeer, n, n2, n3, n4, n5);
        appletPeer.coalesceEvent(paintEvent);
        appletPeer.sendEvent(paintEvent);
    }

    void removeEventsForObject(ObjectPeer objectPeer) {
        AppletPeer appletPeer;
        if (objectPeer != null && (appletPeer = objectPeer.getApplet()) != null) {
            appletPeer.removeEvents(objectPeer);
        }
    }
}

