/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.XEvent;

class MWindowPeer
extends MPanelPeer
implements WindowPeer {
    Insets insets = new Insets(0, 0, 0, 0);
    static Vector allWindows = new Vector();

    native void create(MComponentPeer var1);

    native void pShow();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    MWindowPeer(Window window) {
        super(window);
        Color color;
        Font font;
        allWindows.addElement(this);
        MFramePeer mFramePeer = (MFramePeer)window.getParent().getPeer();
        if (mFramePeer != null) {
            mFramePeer.addWindow(window);
        }
        if ((font = window.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(Color.black);
            this.setForeground(Color.black);
        }
    }

    public void dispose() {
        MFramePeer mFramePeer = (MFramePeer)this.target.getParent().getPeer();
        if (mFramePeer != null) {
            mFramePeer.removeWindow((Window)this.target);
        }
        allWindows.removeElement(this);
        super.dispose();
    }

    public void toFront() {
        this.pShow();
    }

    public native void toBack();

    public Insets insets() {
        return this.insets;
    }

    public void handleQuit() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 201, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 201, null));
    }

    public void handleIconify() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 203, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 203, null));
    }

    public void handleDeiconify() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 204, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 204, null));
    }

    public synchronized void handleResize(int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 207, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.invalidate();
        this.target.validate();
        this.target.repaint();
    }
}

