/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import sun.awt.macos.InterfaceThread;
import sun.awt.macos.MToolkit;
import sun.awt.macos.MacFontMetrics;
import sun.awt.macos.MacGraphics;
import sun.awt.macos.MacImage;

public abstract class MComponentPeer
implements ComponentPeer {
    Component target;
    int pData;
    int pInternationalData;
    int mOwnerPane;
    int mFont;
    int mSize;
    int mStyle;
    Color mForeColor;
    Color mBackColor;
    boolean mRecalculateClip;
    boolean mIsContainer;
    boolean mIsButton;
    boolean mIsChoice;
    boolean mIsResizableFrame;
    int mObscuredRgn;
    int mClipRgn;

    MComponentPeer(Component component) {
        this.target = component;
        Container container = component.getParent();
        this.setup();
        this.create((MComponentPeer)(container != null ? container.getPeer() : null));
        this.initialize();
    }

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    void setup() {
        this.mForeColor = new Color(0, 0, 0);
        this.mBackColor = new Color(192, 192, 192);
        this.pSetup();
    }

    void initialize() {
        Font font;
        Rectangle rectangle = this.target.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.show();
        } else {
            this.hide();
        }
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
    }

    public void dispose() {
        this.pDispose();
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        MacGraphics macGraphics = new MacGraphics(this);
        ((Graphics)macGraphics).setColor(this.target.getForeground());
        ((Graphics)macGraphics).setFont(this.target.getFont());
        return macGraphics;
    }

    public FontMetrics getFontMetrics(Font font) {
        return MacFontMetrics.getFontMetrics(font);
    }

    public void show() {
        this.pShow();
    }

    public void hide() {
        this.pHide();
    }

    public void enable() {
        this.pEnable();
    }

    public void disable() {
        this.pDisable();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.pRepaint(l, n, n2, n3, n4);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.size();
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.target.print(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.pReshape(n, n2, n3, n4);
    }

    public void setForeground(Color color) {
        this.mForeColor = color;
    }

    public void setBackground(Color color) {
        this.mBackColor = color;
    }

    public native void setFont(Font var1);

    public native boolean handleEvent(Event var1);

    public Image createImage(ImageProducer imageProducer) {
        return new MacImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new MacImage(n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public Dimension minimumSize() {
        return this.target.size();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public native void requestFocus();

    public native void nextFocus();

    protected void gotFocus() {
        this.target.postEvent(new Event(this.target, 1004, null));
    }

    protected void lostFocus() {
        this.target.postEvent(new Event(this.target, 1005, null));
    }

    private native void pSetup();

    private native void pShow();

    private native void pHide();

    private native void pEnable();

    private native void pDisable();

    private native void pPrint(Graphics var1);

    private native void pReshape(int var1, int var2, int var3, int var4);

    private native void pRepaint(long var1, int var3, int var4, int var5, int var6);

    private native void pDispose();

    public void finalize() {
        this.dispose();
    }

    protected void handleWindowClosing() {
        this.target.postEvent(new Event(this.target, 201, null));
    }

    void handleExpose() {
        InterfaceThread.postInterfaceEvent(1, this.target, 0, 0, 0, 0, 0L, 0, 0);
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
        InterfaceThread.postInterfaceEvent(2, this.target, n, n2, n3, n4, 0L, 0, 0);
    }

    private int modifiersToJavaFlags(int n) {
        int n2 = 0;
        if ((n & 0x100) != 0) {
            n2 |= 4;
        }
        if ((n & 0x200) != 0) {
            n2 |= 1;
        }
        if ((n & 0x800) != 0) {
            n2 |= 8;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    protected void handleKeyEvent(int n, int n2, int n3, int n4, boolean bl, int n5) {
        long l = 0L;
        int n6 = this.modifiersToJavaFlags(n4);
        boolean bl2 = true;
        l = System.currentTimeMillis();
        switch (n3) {
            case 1: {
                n3 = 1000;
                break;
            }
            case 4: {
                n3 = 1001;
                break;
            }
            case 11: {
                n3 = 1002;
                break;
            }
            case 12: {
                n3 = 1003;
                break;
            }
            case 30: {
                n3 = 1004;
                break;
            }
            case 28: {
                n3 = 1006;
                break;
            }
            case 29: {
                n3 = 1007;
                break;
            }
            case 31: {
                n3 = 1005;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            if (bl) {
                InterfaceThread.postInterfaceEvent(9, this.target, n, n2, 0, 0, l, n6, n3, 0, n5);
                return;
            }
            InterfaceThread.postInterfaceEvent(10, this.target, n, n2, 0, 0, l, n6, n3, 0, n5);
            return;
        }
        if (bl) {
            InterfaceThread.postInterfaceEvent(7, this.target, n, n2, 0, 0, l, n6, n3, 0, n5);
            return;
        }
        InterfaceThread.postInterfaceEvent(8, this.target, n, n2, 0, 0, l, n6, n3, 0, n5);
    }

    protected void handleMouseChanged(int n, int n2, int n3, int n4, boolean bl, int n5) {
        long l = System.currentTimeMillis();
        int n6 = this.modifiersToJavaFlags(n3);
        if (bl) {
            InterfaceThread.postInterfaceEvent(3, this.target, n, n2, 0, 0, l, n6, 0, n4, n5);
            return;
        }
        InterfaceThread.postInterfaceEvent(4, this.target, n, n2, 0, 0, l, n6, 0, n4, n5);
    }

    protected void handleMouseMoved(int n, int n2, int n3, boolean bl) {
        long l = System.currentTimeMillis();
        int n4 = this.modifiersToJavaFlags(n3);
        if (bl) {
            InterfaceThread.postInterfaceEvent(6, this.target, n, n2, 0, 0, l, n4, 0);
            return;
        }
        InterfaceThread.postInterfaceEvent(5, this.target, n, n2, 0, 0, l, n4, 0);
    }

    protected void handleMouseEnter(int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        int n4 = this.modifiersToJavaFlags(n3);
        InterfaceThread.postInterfaceEvent(11, this.target, n, n2, 0, 0, l, n4, 0);
    }

    protected void handleMouseExit(int n, int n2, int n3) {
        long l = System.currentTimeMillis();
        int n4 = this.modifiersToJavaFlags(n3);
        InterfaceThread.postInterfaceEvent(12, this.target, n, n2, 0, 0, l, n4, 0);
    }
}

