/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import sun.awt.image.ImageInfoGrabber;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.OffScreenImageSource;

public abstract class Image
extends java.awt.Image {
    ImageProducer source;
    InputStreamImageSource src;
    ImageInfoGrabber info;
    private int width = -1;
    private int height = -1;
    private Hashtable properties;
    private int availinfo;
    Hashtable representations = new Hashtable();
    ImageRepresentation baseIR;

    protected Image() {
    }

    protected Image(int n, int n2) {
        OffScreenImageSource offScreenImageSource = new OffScreenImageSource(null, n, n2);
        this.source = offScreenImageSource;
        this.width = n;
        this.height = n2;
        this.availinfo |= 3;
        ImageRepresentation imageRepresentation = this.getImageRep(-1, -1);
        this.representations.put(String.valueOf(n) + "x" + n2, imageRepresentation);
        this.representations.put("-1x-1", imageRepresentation);
        imageRepresentation.setDimensions(n, n2);
        imageRepresentation.offscreenInit102();
        offScreenImageSource.setImageRep(imageRepresentation);
    }

    protected Image(Component component, int n, int n2) {
        OffScreenImageSource offScreenImageSource = new OffScreenImageSource(component, n, n2);
        this.source = offScreenImageSource;
        this.width = n;
        this.height = n2;
        this.availinfo |= 3;
        ImageRepresentation imageRepresentation = this.getImageRep(-1, -1);
        this.representations.put(String.valueOf(n) + "x" + n2, imageRepresentation);
        this.representations.put("-1x-1", imageRepresentation);
        this.baseIR = imageRepresentation;
        imageRepresentation.setDimensions(n, n2);
        imageRepresentation.offscreenInit(component.getBackground());
        offScreenImageSource.setImageRep(imageRepresentation);
    }

    protected Image(ImageProducer imageProducer) {
        this.source = imageProducer;
        if (imageProducer instanceof InputStreamImageSource) {
            this.src = (InputStreamImageSource)imageProducer;
        }
        this.info = new ImageInfoGrabber(this);
        this.info.setupConsumer();
    }

    public ImageProducer getSource() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        return this.source;
    }

    protected void initGraphics(Graphics graphics) {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)this.source;
        graphics.setColor(offScreenImageSource.target.getForeground());
        graphics.setFont(offScreenImageSource.target.getFont());
    }

    public Color getBackground() {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)this.source;
        return offScreenImageSource.target.getBackground();
    }

    public int getWidth() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 1) == 0) {
            this.reconstruct(1);
        }
        return this.width;
    }

    public synchronized int getWidth(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 1) == 0) {
            this.addWatcher(imageObserver, true);
            return -1;
        }
        return this.width;
    }

    public int getHeight() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 2) == 0) {
            this.reconstruct(2);
        }
        return this.height;
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 2) == 0) {
            this.addWatcher(imageObserver, true);
            return -1;
        }
        return this.height;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if (this.properties == null) {
            this.addWatcher(imageObserver, true);
            return null;
        }
        Object object = this.properties.get(string);
        if (object == null) {
            object = java.awt.Image.UndefinedProperty;
        }
        return object;
    }

    public boolean hasError() {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        return (this.availinfo & 0x40) != 0;
    }

    public int check(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) == 0 && (~this.availinfo & 7) != 0) {
            this.addWatcher(imageObserver, false);
        }
        return this.availinfo;
    }

    public void preload(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x20) == 0) {
            this.addWatcher(imageObserver, true);
        }
    }

    private synchronized void addWatcher(ImageObserver imageObserver, boolean bl) {
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this, 192, -1, -1, -1, -1);
            }
            return;
        }
        if (this.info == null) {
            this.info = new ImageInfoGrabber(this);
            this.info.setupConsumer();
        }
        this.info.addWatcher(imageObserver);
        if (bl) {
            this.info.getInfo();
        }
    }

    private synchronized void reconstruct(int n) {
        if ((n & ~this.availinfo) != 0) {
            if ((this.availinfo & 0x40) != 0) {
                return;
            }
            if (this.info == null) {
                this.info = new ImageInfoGrabber(this);
            }
            this.info.getInfo();
            while ((n & ~this.availinfo) != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if ((this.availinfo & 0x40) == 0) continue;
                return;
            }
        }
    }

    synchronized void addInfo(int n) {
        this.availinfo |= n;
        this.notifyAll();
        if ((~this.availinfo & 7) == 0) {
            this.info.stopInfo();
        }
    }

    void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.addInfo(3);
    }

    void setProperties(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.properties = hashtable;
        this.addInfo(4);
    }

    synchronized void infoDone(int n) {
        if (n == 1 || (~this.availinfo & 3) != 0) {
            this.addInfo(64);
            return;
        }
        if ((this.availinfo & 4) == 0) {
            this.setProperties(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flush() {
        block6: {
            if (this.src != null) {
                this.src.checkSecurity(null, false);
            }
            if (this.source instanceof OffScreenImageSource) break block6;
            var2_1 = this;
            synchronized (var2_1) {
                this.availinfo &= -65;
                var1_2 = this.representations.elements();
                this.representations = new Hashtable();
                this.baseIR = null;
                if (this.source instanceof InputStreamImageSource) {
                    ((InputStreamImageSource)this.source).flush();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var2_1
                if (true) ** GOTO lbl21
            }
            do {
                var2_1 = (ImageRepresentation)var1_2.nextElement();
                var2_1.abort();
lbl21:
                // 2 sources

            } while (var1_2.hasMoreElements());
        }
    }

    protected ImageRepresentation getImageRep(int n, int n2) {
        String string;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if (!(n != -1 && n != this.width || n2 != -1 && n2 != this.height)) {
            if (this.baseIR != null) {
                return this.baseIR;
            }
            string = "-1x-1";
        } else {
            string = String.valueOf(n) + "x" + n2;
        }
        ImageRepresentation imageRepresentation = (ImageRepresentation)this.representations.get(string);
        if (imageRepresentation == null) {
            Image image = this;
            synchronized (image) {
                imageRepresentation = (ImageRepresentation)this.representations.get(string);
                if (imageRepresentation == null) {
                    imageRepresentation = new ImageRepresentation(this, n, n2, 0);
                    if (this.source instanceof OffScreenImageSource) {
                        imageRepresentation.offscreen = true;
                    } else {
                        this.representations.put(string, imageRepresentation);
                    }
                    if (n == -1 && n2 == -1) {
                        this.baseIR = imageRepresentation;
                    }
                }
            }
        }
        return imageRepresentation;
    }
}

