/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.peer.ContainerPeer;
import java.io.PrintStream;

public abstract class Container
extends Component {
    int ncomponents;
    Component[] component = new Component[4];
    LayoutManager layoutMgr;

    Container() {
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public synchronized Component getComponent(int n) {
        if (n < 0 || n >= this.ncomponents) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
        return this.component[n];
    }

    public synchronized Component[] getComponents() {
        Component[] componentArray = new Component[this.ncomponents];
        System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
        return componentArray;
    }

    public Insets insets() {
        ContainerPeer containerPeer = (ContainerPeer)this.peer;
        if (containerPeer != null) {
            return containerPeer.insets();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public synchronized Component add(Component component, int n) {
        Component[] componentArray;
        if (n > this.ncomponents || n < 0 && n != -1) {
            throw new IllegalArgumentException("illegal component position");
        }
        if (component instanceof Container) {
            componentArray = this;
            while (componentArray != null) {
                if (componentArray == component) {
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
                componentArray = componentArray.parent;
            }
        }
        if (component.parent != null) {
            component.parent.remove(component);
        }
        if (this.ncomponents == this.component.length) {
            componentArray = new Component[this.ncomponents * 2];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            this.component = componentArray;
        }
        if (n == -1 || n == this.ncomponents) {
            this.component[this.ncomponents++] = component;
        } else {
            System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
            this.component[n] = component;
            ++this.ncomponents;
        }
        component.parent = this;
        this.invalidate();
        if (this.peer != null) {
            component.addNotify();
        }
        return component;
    }

    public synchronized Component add(String string, Component component) {
        Component component2 = this.add(component);
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.addLayoutComponent(string, component);
        }
        return component2;
    }

    public synchronized void remove(Component component) {
        if (component.parent == this) {
            int n = 0;
            while (n < this.ncomponents) {
                if (this.component[n] == component) {
                    if (this.peer != null) {
                        component.removeNotify();
                    }
                    if (this.layoutMgr != null) {
                        this.layoutMgr.removeLayoutComponent(component);
                    }
                    component.parent = null;
                    System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
                    this.component[--this.ncomponents] = null;
                    this.invalidate();
                    return;
                }
                ++n;
            }
        }
    }

    public synchronized void removeAll() {
        while (this.ncomponents > 0) {
            Component component = this.component[--this.ncomponents];
            this.component[this.ncomponents] = null;
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            component.parent = null;
        }
        this.invalidate();
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        this.invalidate();
    }

    public synchronized void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    public synchronized void validate() {
        super.validate();
        int n = 0;
        while (n < this.ncomponents) {
            Component component = this.component[n];
            if (!component.valid) {
                component.validate();
            }
            ++n;
        }
    }

    public synchronized Dimension preferredSize() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            return layoutManager.preferredLayoutSize(this);
        }
        return super.preferredSize();
    }

    public synchronized Dimension minimumSize() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            return layoutManager.minimumLayoutSize(this);
        }
        return super.minimumSize();
    }

    public void paintComponents(Graphics graphics) {
        int n = 0;
        while (n < this.ncomponents) {
            Component component = this.component[n];
            if (component != null) {
                Graphics graphics2 = graphics.create(component.x, component.y, component.width, component.height);
                try {
                    component.paintAll(graphics2);
                }
                finally {
                    Object var6_5 = null;
                    graphics2.dispose();
                }
            }
            ++n;
        }
    }

    public void printComponents(Graphics graphics) {
        int n = 0;
        while (n < this.ncomponents) {
            Component component = this.component[n];
            if (component != null) {
                Graphics graphics2 = graphics.create(component.x, component.y, component.width, component.height);
                try {
                    component.printAll(graphics2);
                }
                finally {
                    Object var6_5 = null;
                    graphics2.dispose();
                }
            }
            ++n;
        }
    }

    public void deliverEvent(Event event) {
        Component component = this.locate(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
            return;
        }
        this.postEvent(event);
    }

    public Component locate(int n, int n2) {
        if (!this.inside(n, n2)) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.ncomponents) {
            Component component = this.component[n3];
            if (component != null && component.inside(n - component.x, n2 - component.y)) {
                return component;
            }
            ++n3;
        }
        return this;
    }

    public synchronized void addNotify() {
        int n = 0;
        while (n < this.ncomponents) {
            this.component[n].addNotify();
            ++n;
        }
        super.addNotify();
    }

    public synchronized void removeNotify() {
        int n = 0;
        while (n < this.ncomponents) {
            this.component[n].removeNotify();
            ++n;
        }
        super.removeNotify();
    }

    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = String.valueOf(string) + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        int n2 = 0;
        while (n2 < this.ncomponents) {
            Component component = this.component[n2];
            if (component != null) {
                component.list(printStream, n + 1);
            }
            ++n2;
        }
    }
}

