/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager,
Serializable {
    int hgap;
    int vgap;
    Component north;
    Component west;
    Component east;
    Component south;
    Component center;

    public BorderLayout() {
    }

    public BorderLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
        if ("Center".equals(string)) {
            this.center = component;
            return;
        }
        if ("North".equals(string)) {
            this.north = component;
            return;
        }
        if ("South".equals(string)) {
            this.south = component;
            return;
        }
        if ("East".equals(string)) {
            this.east = component;
            return;
        }
        if ("West".equals(string)) {
            this.west = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.center) {
            this.center = null;
            return;
        }
        if (component == this.north) {
            this.north = null;
            return;
        }
        if (component == this.south) {
            this.south = null;
            return;
        }
        if (component == this.east) {
            this.east = null;
            return;
        }
        if (component == this.west) {
            this.west = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        if (this.east != null && this.east.visible) {
            serializable = this.east.minimumSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.west != null && this.west.visible) {
            serializable = this.west.minimumSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.center != null && this.center.visible) {
            serializable = this.center.minimumSize();
            dimension.width += serializable.width;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.north != null && this.north.visible) {
            serializable = this.north.minimumSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        if (this.south != null && this.south.visible) {
            serializable = this.south.minimumSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        if (this.east != null && this.east.visible) {
            serializable = this.east.preferredSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.west != null && this.west.visible) {
            serializable = this.west.preferredSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.center != null && this.center.visible) {
            serializable = this.center.preferredSize();
            dimension.width += serializable.width;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.north != null && this.north.visible) {
            serializable = this.north.preferredSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        if (this.south != null && this.south.visible) {
            serializable = this.south.preferredSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Insets insets = container.insets();
        int n = insets.top;
        int n2 = container.height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.width - insets.right;
        if (this.north != null && this.north.visible) {
            this.north.resize(n4 - n3, this.north.height);
            dimension = this.north.preferredSize();
            this.north.reshape(n3, n, n4 - n3, dimension.height);
            n += dimension.height + this.vgap;
        }
        if (this.south != null && this.south.visible) {
            this.south.resize(n4 - n3, this.south.height);
            dimension = this.south.preferredSize();
            this.south.reshape(n3, n2 - dimension.height, n4 - n3, dimension.height);
            n2 -= dimension.height + this.vgap;
        }
        if (this.east != null && this.east.visible) {
            this.east.resize(this.east.width, n2 - n);
            dimension = this.east.preferredSize();
            this.east.reshape(n4 - dimension.width, n, dimension.width, n2 - n);
            n4 -= dimension.width + this.hgap;
        }
        if (this.west != null && this.west.visible) {
            this.west.resize(this.west.width, n2 - n);
            dimension = this.west.preferredSize();
            this.west.reshape(n3, n, dimension.width, n2 - n);
            n3 += dimension.width + this.hgap;
        }
        if (this.center != null && this.center.visible) {
            this.center.reshape(n3, n, n4 - n3, n2 - n);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }
}

