/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import netscape.ldap.client.JDAPAttribute;
import netscape.ldap.client.JDAPModification;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class LDIF {
    public static final String SEPARATOR = ":";
    public static final String COMMENT = "#";
    private Vector m_records = new Vector();
    private int m_version = 1;

    public LDIF(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        this.parse_ldif_file(dataInputStream);
    }

    public LDIF(DataInputStream dataInputStream) throws IOException {
        this.parse_ldif_file(dataInputStream);
    }

    public String readLine(DataInputStream dataInputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        String string = null;
        do {
            if ((string = bufferedReader.readLine()) == null) continue;
            string.trim();
        } while (string != null && string.startsWith(COMMENT));
        return string;
    }

    public void parse_ldif_file(DataInputStream dataInputStream) throws IOException {
        LDIFRecord lDIFRecord = null;
        do {
            if ((lDIFRecord = this.parse_ldif_record(dataInputStream)) == null) continue;
            this.m_records.addElement(lDIFRecord);
        } while (lDIFRecord != null);
    }

    public LDIFRecord parse_ldif_record(DataInputStream dataInputStream) throws IOException {
        String string = null;
        String string2 = null;
        new Vector();
        LDIFRecord lDIFRecord = null;
        string = this.readLine(dataInputStream);
        if (string == null) {
            return null;
        }
        if (!string.startsWith("dn:")) {
            throw new IOException("no dn found");
        }
        string2 = string.substring(3).trim();
        LDIFContent lDIFContent = this.parse_ldif_content(dataInputStream);
        lDIFRecord = new LDIFRecord(string2, lDIFContent);
        return lDIFRecord;
    }

    public LDIFContent parse_ldif_content(DataInputStream dataInputStream) throws IOException {
        Object object;
        String string = null;
        string = this.readLine(dataInputStream);
        if (string.startsWith("changetype:")) {
            String string2 = string.substring(11).trim();
            if (string2.equals("modify")) {
                LDIFModifyContent lDIFModifyContent = this.parse_mod_spec(dataInputStream);
                return lDIFModifyContent;
            }
            if (string2.equals("add")) {
                LDIFAddContent lDIFAddContent = this.parse_add_spec(dataInputStream);
                return lDIFAddContent;
            }
            if (string2.equals("delete")) {
                LDIFDeleteContent lDIFDeleteContent = this.parse_delete_spec(dataInputStream);
                return lDIFDeleteContent;
            }
            throw new IOException("change type not supported");
        }
        LDIFAttributeContent lDIFAttributeContent = new LDIFAttributeContent();
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        do {
            int n;
            if ((n = string.indexOf(58)) == -1) {
                throw new IOException("no ':' found in entry");
            }
            String string4 = string.substring(0, n);
            if (string3 == null || string4.equals(string3)) {
                vector.addElement(string.substring(n + 1).trim());
            } else {
                object = new String[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    object[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
                JDAPAttribute jDAPAttribute = new JDAPAttribute(string3, (String[])object);
                vector.removeAllElements();
                lDIFAttributeContent.addElement(jDAPAttribute);
                vector.addElement(string.substring(n + 1).trim());
            }
            string3 = string4;
        } while ((string = this.readLine(dataInputStream)) != null && !string.equals("") && !string.equals("-"));
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            object = new JDAPAttribute(string3, stringArray);
            lDIFAttributeContent.addElement((JDAPAttribute)object);
        }
        return lDIFAttributeContent;
    }

    public LDIFAddContent parse_add_spec(DataInputStream dataInputStream) throws IOException {
        LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)this.parse_ldif_content(dataInputStream);
        JDAPAttribute[] jDAPAttributeArray = lDIFAttributeContent.getAttributes();
        LDIFAddContent lDIFAddContent = new LDIFAddContent(jDAPAttributeArray);
        return lDIFAddContent;
    }

    public LDIFDeleteContent parse_delete_spec(DataInputStream dataInputStream) throws IOException {
        String string = this.readLine(dataInputStream);
        if (string == null || string.equals("")) {
            LDIFDeleteContent lDIFDeleteContent = new LDIFDeleteContent();
            return lDIFDeleteContent;
        }
        throw new IOException("invalid SEP");
    }

    public LDIFModifyContent parse_mod_spec(DataInputStream dataInputStream) throws IOException {
        String string = null;
        string = this.readLine(dataInputStream);
        LDIFModifyContent lDIFModifyContent = new LDIFModifyContent();
        do {
            int n;
            if (string.startsWith("add:")) {
                n = 0;
            } else if (string.startsWith("delete:")) {
                n = 1;
            } else if (string.startsWith("replace:")) {
                n = 2;
            } else {
                throw new IOException("unknown modify type");
            }
            LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)this.parse_ldif_content(dataInputStream);
            JDAPAttribute[] jDAPAttributeArray = lDIFAttributeContent.getAttributes();
            int n2 = 0;
            while (n2 < jDAPAttributeArray.length) {
                lDIFModifyContent.addElement(new JDAPModification(n, jDAPAttributeArray[n2]));
                ++n2;
            }
        } while ((string = this.readLine(dataInputStream)) != null && !string.equals(""));
        return lDIFModifyContent;
    }

    public int getVersion() {
        return this.m_version;
    }

    public LDIFRecord elementAt(int n) {
        return (LDIFRecord)this.m_records.elementAt(n);
    }

    public int size() {
        return this.m_records.size();
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.size()) {
            string = String.valueOf(string) + this.elementAt(n).toString();
            ++n;
        }
        return "LDIF {" + string + "}";
    }
}

