/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class JDAPAttribute {
    protected String m_type;
    protected String[] m_vals;
    protected BERElement m_element;

    public JDAPAttribute(String string, String[] stringArray) {
        this.m_type = string;
        this.m_vals = stringArray;
    }

    public JDAPAttribute(BERElement bERElement) throws IOException {
        BERSequence bERSequence = (BERSequence)bERElement;
        BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(0);
        byte[] byArray = null;
        byArray = bEROctetString.getValue();
        if (byArray == null) {
            this.m_type = null;
        } else {
            try {
                this.m_type = new String(byArray, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        BERSet bERSet = (BERSet)bERSequence.elementAt(1);
        if (bERSet.size() > 0) {
            this.m_vals = new String[bERSet.size()];
            int n = 0;
            while (n < bERSet.size()) {
                BEROctetString bEROctetString2 = (BEROctetString)bERSet.elementAt(n);
                byArray = bEROctetString2.getValue();
                if (byArray == null) {
                    this.m_vals[n] = null;
                } else {
                    try {
                        this.m_vals[n] = new String(byArray, "UTF8");
                    }
                    catch (Throwable throwable) {}
                }
                ++n;
            }
        }
    }

    public BERElement getBERElement() {
        if (this.m_element != null) {
            return this.m_element;
        }
        try {
            BERSequence bERSequence = new BERSequence();
            bERSequence.addElement(new BEROctetString(this.m_type));
            BERSet bERSet = new BERSet();
            if (this.m_vals != null) {
                int n = 0;
                while (n < this.m_vals.length) {
                    bERSet.addElement(new BEROctetString(this.m_vals[n]));
                    ++n;
                }
            }
            bERSequence.addElement(bERSet);
            return bERSequence;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getType() {
        return this.m_type;
    }

    public String[] getValues() {
        return this.m_vals;
    }

    public String getParamString() {
        String string = "";
        if (this.m_vals != null) {
            int n = 0;
            while (n < this.m_vals.length) {
                if (n != 0) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + this.m_vals[n];
                ++n;
            }
        }
        return "{type='" + this.m_type + "', values='" + string + "'}";
    }

    public String toString() {
        return "JDAPAttribute " + this.getParamString();
    }
}

