/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.client.JDAPAttribute;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;

public class LDAPSearchResults
implements Enumeration {
    private int current = 0;
    private Vector entries = new Vector();
    private LDAPSearchListener resultSource;
    private boolean searchComplete = true;
    private LDAPConnection connectionToClose = null;

    void add(JDAPSearchResponse jDAPSearchResponse) {
        Object object;
        JDAPAttribute[] jDAPAttributeArray = jDAPSearchResponse.getAttributes();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        if (jDAPAttributeArray != null) {
            int n = 0;
            while (n < jDAPAttributeArray.length) {
                object = jDAPAttributeArray[n];
                String string = ((JDAPAttribute)object).getType();
                String[] stringArray = ((JDAPAttribute)object).getValues();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(string, stringArray);
                lDAPAttributeSet.add(lDAPAttribute);
                ++n;
            }
        }
        String string = jDAPSearchResponse.getObjectName();
        object = new LDAPEntry(string, lDAPAttributeSet);
        this.entries.addElement(object);
    }

    void associate(LDAPSearchListener lDAPSearchListener) {
        this.resultSource = lDAPSearchListener;
        this.searchComplete = false;
    }

    void closeOnCompletion(LDAPConnection lDAPConnection) {
        if (this.searchComplete) {
            try {
                lDAPConnection.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                return;
            }
        }
        this.connectionToClose = lDAPConnection;
    }

    void quicksort(LDAPEntry[] lDAPEntryArray, LDAPEntryComparator lDAPEntryComparator, int n, int n2) {
        if (n >= n2) {
            return;
        }
        LDAPEntry lDAPEntry = lDAPEntryArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (lDAPEntryComparator.isGreater(lDAPEntryArray[--n4], lDAPEntry)) {
                continue;
            }
            while (lDAPEntryComparator.isGreater(lDAPEntry, lDAPEntryArray[++n3])) {
            }
            if (n3 >= n4) break;
            LDAPEntry lDAPEntry2 = lDAPEntryArray[n3];
            lDAPEntryArray[n3] = lDAPEntryArray[n4];
            lDAPEntryArray[n4] = lDAPEntry2;
        }
        this.quicksort(lDAPEntryArray, lDAPEntryComparator, n, n4);
        this.quicksort(lDAPEntryArray, lDAPEntryComparator, n4 + 1, n2);
    }

    public synchronized void sort(LDAPEntryComparator lDAPEntryComparator) {
        while (!this.searchComplete) {
            this.fetchResult();
        }
        int n = this.entries.size();
        if (n <= 0) {
            return;
        }
        Object[] objectArray = new LDAPEntry[n];
        this.entries.copyInto(objectArray);
        this.quicksort((LDAPEntry[])objectArray, lDAPEntryComparator, 0, n - 1);
        this.entries.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this.entries.addElement(objectArray[n2]);
            ++n2;
        }
        this.current = 0;
    }

    public LDAPEntry next() {
        return (LDAPEntry)this.nextElement();
    }

    public Object nextElement() {
        if (this.current >= this.entries.size() - 1) {
            this.fetchResult();
        }
        if (this.current < this.entries.size()) {
            ++this.current;
            Object e = this.entries.elementAt(this.current - 1);
            this.entries.setElementAt(null, this.current - 1);
            return e;
        }
        return null;
    }

    public boolean hasMoreElements() {
        if (this.current >= this.entries.size() - 1) {
            this.fetchResult();
        }
        return this.current < this.entries.size();
    }

    private synchronized void fetchResult() {
        if (this.resultSource != null) {
            if (this.searchComplete) {
                return;
            }
            JDAPMessage jDAPMessage = this.resultSource.nextResult();
            if (jDAPMessage == null) {
                this.searchComplete = true;
                if (this.connectionToClose != null) {
                    try {
                        this.connectionToClose.disconnect();
                    }
                    catch (LDAPException lDAPException) {}
                    this.connectionToClose = null;
                }
                return;
            }
            jDAPMessage.getProtocolOp().getType();
            JDAPProtocolOp jDAPProtocolOp = jDAPMessage.getProtocolOp();
            JDAPSearchResponse jDAPSearchResponse = (JDAPSearchResponse)jDAPProtocolOp;
            this.add(jDAPSearchResponse);
        }
    }
}

