/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.JDAPControl;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
extends Thread {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private transient int m_highMsgId = 0;
    private transient InputStream m_serverInput;
    private transient OutputStream m_serverOutput;
    private transient Hashtable m_requests = new Hashtable();
    private transient Vector m_registered = new Vector();

    public LDAPConnThread(String string, int n, LDAPSocketFactory lDAPSocketFactory) throws LDAPException {
        try {
            Socket socket = lDAPSocketFactory == null ? new Socket(string, n) : lDAPSocketFactory.makeSocket(string, n);
            this.m_serverInput = new BufferedInputStream(socket.getInputStream());
            this.m_serverOutput = new BufferedOutputStream(socket.getOutputStream());
        }
        catch (IOException iOException) {
            throw new LDAPException("failed to connect to server");
        }
        this.start();
    }

    public synchronized void sendRequest(JDAPProtocolOp jDAPProtocolOp, LDAPResponseListener lDAPResponseListener, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        JDAPMessage jDAPMessage;
        if (this.m_serverOutput == null) {
            throw new LDAPException("not connected to a server");
        }
        LDAPControl[] lDAPControlArray = lDAPSearchConstraints.getServerControls();
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            JDAPControl[] jDAPControlArray = new JDAPControl[lDAPControlArray.length];
            int n = 0;
            while (n < lDAPControlArray.length) {
                jDAPControlArray[n] = new JDAPControl(lDAPControlArray[n].getID(), lDAPControlArray[n].isCritical(), lDAPControlArray[n].getValue());
                ++n;
            }
            jDAPMessage = new JDAPMessage(this.allocateId(), jDAPProtocolOp, jDAPControlArray);
        } else {
            jDAPMessage = new JDAPMessage(this.allocateId(), jDAPProtocolOp);
        }
        if (!(jDAPProtocolOp instanceof JDAPAbandonRequest) && !(jDAPProtocolOp instanceof JDAPUnbindRequest)) {
            this.m_requests.put(new Integer(jDAPMessage.getId()), lDAPResponseListener);
        }
        try {
            jDAPMessage.write(this.m_serverOutput);
            this.m_serverOutput.flush();
            return;
        }
        catch (IOException iOException) {
            throw new LDAPException("error writing request");
        }
    }

    public synchronized void register(LDAPConnection lDAPConnection) {
        if (!this.m_registered.contains(lDAPConnection)) {
            this.m_registered.addElement(lDAPConnection);
        }
    }

    public synchronized void deregister(LDAPConnection lDAPConnection) {
        this.m_registered.removeElement(lDAPConnection);
        if (this.m_registered.size() == 0) {
            try {
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                this.sendRequest(new JDAPUnbindRequest(), null, lDAPSearchConstraints);
                this.stop();
                Thread.sleep(100L);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void run() {
        JDAPMessage jDAPMessage = null;
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        while (true) {
            Thread.yield();
            int[] nArray = new int[]{0};
            try {
                BERElement bERElement = BERElement.getElement(jDAPBERTagDecoder, this.m_serverInput, nArray);
                jDAPMessage = new JDAPMessage(bERElement);
                this.processResponse(jDAPMessage);
                continue;
            }
            catch (Exception exception) {
                this.networkError(exception);
                continue;
            }
            break;
        }
    }

    private synchronized int allocateId() {
        this.m_highMsgId = (this.m_highMsgId + 1) % Integer.MAX_VALUE;
        return this.m_highMsgId;
    }

    private void processResponse(JDAPMessage jDAPMessage) {
        Integer n = new Integer(jDAPMessage.getId());
        LDAPResponseListener lDAPResponseListener = (LDAPResponseListener)this.m_requests.get(n);
        if (lDAPResponseListener == null) {
            return;
        }
        JDAPProtocolOp jDAPProtocolOp = jDAPMessage.getProtocolOp();
        if (jDAPProtocolOp instanceof JDAPSearchResponse) {
            ((LDAPSearchListener)lDAPResponseListener).addSearchResult(jDAPMessage);
            return;
        }
        lDAPResponseListener.setResponse(jDAPMessage);
        this.m_requests.remove(n);
    }

    private synchronized void networkError(Exception exception) {
        try {
            Enumeration enumeration = this.m_registered.elements();
            while (enumeration.hasMoreElements()) {
                LDAPConnection lDAPConnection = (LDAPConnection)enumeration.nextElement();
                lDAPConnection.networkError(exception);
            }
            this.m_requests.clear();
            this.m_serverOutput.close();
            this.m_serverInput.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {}
        this.m_serverOutput = null;
        this.m_serverInput = null;
    }
}

