/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.client.JDAPAttribute;

public class LDAPAttributeSet {
    private int current;
    private Vector attrs;
    Hashtable attrHash;

    public LDAPAttributeSet() {
        this.attrs = new Vector();
        this.attrHash = new Hashtable();
        this.current = 0;
    }

    LDAPAttributeSet(JDAPAttribute[] jDAPAttributeArray) {
        this.attrs = new Vector();
        this.attrHash = new Hashtable();
        this.current = 0;
        int n = 0;
        while (n < jDAPAttributeArray.length) {
            JDAPAttribute jDAPAttribute = jDAPAttributeArray[n];
            String string = jDAPAttribute.getType();
            String[] stringArray = jDAPAttribute.getValues();
            LDAPAttribute lDAPAttribute = new LDAPAttribute(string, stringArray);
            this.attrs.addElement(lDAPAttribute);
            this.attrHash.put(string, lDAPAttribute);
            ++n;
        }
    }

    protected LDAPAttributeSet(LDAPAttributeSet lDAPAttributeSet) {
        LDAPAttributeSet lDAPAttributeSet2 = this;
        synchronized (lDAPAttributeSet2) {
            this.attrs = (Vector)lDAPAttributeSet.attrs.clone();
        }
        this.attrHash = new Hashtable();
        int n = 0;
        while (n < this.attrs.size()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attrs.elementAt(n);
            this.attrHash.put(lDAPAttribute.getName(), lDAPAttribute);
            ++n;
        }
        this.current = 0;
    }

    public Enumeration getAttributes() {
        return this.attrs.elements();
    }

    public LDAPAttributeSet getSubset(String string) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        if (string == null) {
            return lDAPAttributeSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.countTokens() < 1) {
            return lDAPAttributeSet;
        }
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        Enumeration enumeration = this.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            if (!lDAPAttribute.hasSubtypes(stringArray)) continue;
            lDAPAttributeSet.add(new LDAPAttribute(lDAPAttribute));
        }
        return lDAPAttributeSet;
    }

    public LDAPAttribute getBaseAttribute(String string) {
        return (LDAPAttribute)this.attrHash.get(string);
    }

    public LDAPAttribute[] getAttribute(String string) {
        LDAPAttribute[] lDAPAttributeArray;
        String string2 = LDAPAttribute.getBaseName(string);
        String[] stringArray = LDAPAttribute.getSubtypes(string);
        Vector<LDAPAttribute[]> vector = new Vector<LDAPAttribute[]>();
        int n = 0;
        while (n < this.attrs.size()) {
            lDAPAttributeArray = (LDAPAttribute[])this.attrs.elementAt(n);
            if (lDAPAttributeArray.getBaseName().equalsIgnoreCase(string2)) {
                if (stringArray == null || stringArray.length < 1) {
                    vector.addElement(lDAPAttributeArray);
                } else if (lDAPAttributeArray.hasSubtypes(stringArray)) {
                    vector.addElement(lDAPAttributeArray);
                }
            }
            ++n;
        }
        lDAPAttributeArray = null;
        if (vector.size() > 0) {
            lDAPAttributeArray = new LDAPAttribute[vector.size()];
            int n2 = 0;
            while (n2 < vector.size()) {
                lDAPAttributeArray[n2] = (LDAPAttribute)vector.elementAt(n2);
                ++n2;
            }
        }
        return lDAPAttributeArray;
    }

    public LDAPAttribute elementAt(int n) {
        return (LDAPAttribute)this.attrs.elementAt(n);
    }

    public void removeElementAt(int n) {
        this.attrs.removeElementAt(n);
    }

    public int size() {
        return this.attrs.size();
    }

    public synchronized void add(LDAPAttribute lDAPAttribute) {
        this.attrs.addElement(lDAPAttribute);
        this.attrHash.put(lDAPAttribute.getName(), lDAPAttribute);
    }

    public synchronized void remove(String string) {
        int n = 0;
        while (n < this.attrs.size()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this.attrs.elementAt(n);
            if (string.equalsIgnoreCase(lDAPAttribute.getName())) {
                this.attrs.removeElementAt(n);
                return;
            }
            ++n;
        }
    }
}

