/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttrStrEnumeration;

public class LDAPAttribute {
    private String name;
    private Vector values;

    public LDAPAttribute(LDAPAttribute lDAPAttribute) {
        this.name = lDAPAttribute.name;
        this.values = (Vector)lDAPAttribute.values.clone();
    }

    public LDAPAttribute(String string) {
        this.name = string;
        this.values = new Vector();
    }

    public LDAPAttribute(String string, byte[] byArray) {
        this.name = string;
        this.values = new Vector();
        this.addValue(byArray);
    }

    public LDAPAttribute(String string, String string2) {
        this.name = string;
        this.values = new Vector();
        this.addValue(string2);
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this.name = string;
        this.values = new Vector();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addValue(stringArray[n]);
                ++n;
            }
            return;
        }
        this.addValue((String)null);
    }

    public int size() {
        return this.values.size();
    }

    public Enumeration getStringValues() {
        return new LDAPAttrStrEnumeration(this.values);
    }

    public Enumeration getByteValues() {
        return this.values.elements();
    }

    public String getName() {
        return this.name;
    }

    public static String[] getSubtypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n++] = (String)stringTokenizer.nextElement();
            }
            return stringArray;
        }
        return null;
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.name);
    }

    public static String getBaseName(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
        }
        return string2;
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.name);
    }

    public boolean hasSubtype(String string) {
        String[] stringArray = this.getSubtypes();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.hasSubtype(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void addValue(String string) {
        if (string == null) {
            this.values.addElement(string);
            return;
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.values.addElement(byArray);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public synchronized void addValue(byte[] byArray) {
        this.values.addElement(byArray);
    }

    public synchronized void removeValue(String string) {
        if (string == null) {
            this.values.addElement(string);
            return;
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.values.removeElement(byArray);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public synchronized void removeValue(byte[] byArray) {
        this.values.removeElement(byArray);
    }
}

