/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.awt.peer.TextAreaPeer;
import sun.awt.motif.MComponentPeer;

public class MTextAreaPeer
extends MComponentPeer
implements TextAreaPeer {
    native void create(MComponentPeer var1);

    void initialize() {
        TextArea textArea = (TextArea)this.target;
        String string = textArea.getText();
        if (string != null) {
            this.setText(string);
        }
        this.select(textArea.getSelectionStart(), textArea.getSelectionEnd());
        this.setEditable(textArea.isEditable());
        super.initialize();
    }

    public MTextAreaPeer(TextArea textArea) {
        super(textArea);
    }

    public void setEditable(boolean bl) {
        this.pSetEditable(bl);
        this.setBackground(this.target.getBackground());
    }

    public void setBackground(Color color) {
        TextArea textArea = (TextArea)this.target;
        super.setBackground(color);
        if (textArea.isEditable()) {
            this.setTextBackground(color.brighter());
        }
    }

    native int getExtraWidth();

    native int getExtraHeight();

    public native void setTextBackground(Color var1);

    public native void pSetEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native String getText();

    public native void insertText(String var1, int var2);

    public native void replaceText(String var1, int var2, int var3);

    public native void setFont(Font var1);

    public Dimension minimumSize() {
        return this.minimumSize(10, 60);
    }

    public Dimension preferredSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    public Dimension minimumSize(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int n3 = fontMetrics.charWidth('0');
        int n4 = fontMetrics.getHeight() - fontMetrics.getLeading();
        return new Dimension(n2 * n3 + this.getExtraWidth(), n * n4 + this.getExtraHeight());
    }
}

