/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.XEvent;

class MDialogPeer
extends MPanelPeer
implements DialogPeer {
    Insets insets;
    Thread currentThread;
    static Vector allDialogs = new Vector();

    native void create(MComponentPeer var1, Object var2);

    native void pSetTitle(String var1);

    native void pShow();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    public native void setResizable(boolean var1);

    MDialogPeer(Dialog dialog) {
        super(dialog, new Insets(Integer.getInteger("awt.frame.topInset", 25), Integer.getInteger("awt.frame.leftInset", 5), Integer.getInteger("awt.frame.bottomInset", 5), Integer.getInteger("awt.frame.rightInset", 5)));
        Color color;
        Font font;
        allDialogs.addElement(this);
        MFramePeer mFramePeer = (MFramePeer)dialog.getParent().getPeer();
        if (mFramePeer != null) {
            mFramePeer.addWindow(dialog);
        }
        if (dialog.getTitle() != null) {
            this.pSetTitle(dialog.getTitle());
        }
        if ((font = dialog.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            dialog.setFont(font);
            this.setFont(font);
        }
        if ((color = dialog.getBackground()) == null) {
            dialog.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = dialog.getForeground()) == null) {
            dialog.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        this.setResizable(dialog.isResizable());
    }

    public void show() {
        if (((Dialog)this.target).isModal()) {
            this.currentThread = Thread.currentThread();
            if (this.applet != null && this.currentThread == this.applet.getAppletThread()) {
                this.pShow();
                this.applet.enterModal();
            } else {
                this.pShow();
                Component component = this.target;
                synchronized (component) {
                    try {
                        this.target.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.currentThread = null;
            return;
        }
        super.show();
    }

    public void hide() {
        if (((Dialog)this.target).isModal() && this.currentThread != null) {
            if (this.applet != null && this.currentThread == this.applet.getAppletThread()) {
                this.applet.exitModal();
            } else {
                Component component = this.target;
                synchronized (component) {
                    try {
                        this.target.notifyAll();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {}
                }
            }
            this.pHide();
            return;
        }
        super.hide();
    }

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public void dispose() {
        MFramePeer mFramePeer = (MFramePeer)this.target.getParent().getPeer();
        if (mFramePeer != null) {
            mFramePeer.removeWindow((Window)this.target);
        }
        allDialogs.removeElement(this);
        this.hide();
        super.dispose();
    }

    public synchronized void handleMoved(int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 0L, 205, n, n2, 0, 0), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 0L, 205, n, n2, 0, 0));
    }

    public void handleQuit() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 201, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 201, null));
    }

    public void handleIconify() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 203, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 203, null));
    }

    public void handleDeiconify() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 204, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 204, null));
    }

    public void toFront() {
        this.pShow();
    }

    public native void toBack();

    public Insets insets() {
        return this.insets;
    }

    public synchronized void handleResize(int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 207, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.invalidate();
        this.target.validate();
        this.target.repaint();
    }
}

