/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.PixelStore;
import sun.awt.image.PixelStore32;
import sun.awt.image.PixelStore8;

public class JPEGImageDecoder
extends ImageDecoder {
    private static ColorModel RGBcolormodel;
    private static ColorModel Graycolormodel;
    PixelStore store;
    Hashtable props = new Hashtable();
    private static final int hintflags = 22;

    private native void readImage(InputStream var1, byte[] var2) throws ImageFormatException;

    public JPEGImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    public synchronized boolean catchupConsumer(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        return this.store == null || this.store.replay(inputStreamImageSource, imageConsumer);
    }

    public synchronized void makeStore(int n, int n2, boolean bl) {
        if (bl) {
            this.store = new PixelStore8(n, n2);
            return;
        }
        this.store = new PixelStore32(n, n2);
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    public boolean sendHeaderInfo(int n, int n2, boolean bl, boolean bl2) {
        this.source.setDimensions(n, n2);
        this.makeStore(n, n2, bl);
        this.source.setProperties(this.props);
        this.store.setProperties(this.props);
        ColorModel colorModel = bl ? Graycolormodel : RGBcolormodel;
        this.source.setColorModel(colorModel);
        this.store.setColorModel(colorModel);
        int n3 = 22;
        if (!bl2) {
            n3 |= 8;
        }
        this.source.setHints(22);
        this.store.setHints(22);
        return true;
    }

    public boolean sendPixels(int[] nArray, int n) {
        int n2 = this.source.setPixels(0, n, nArray.length, 1, RGBcolormodel, nArray, 0, nArray.length);
        if (this.store.setPixels(0, n, nArray.length, 1, nArray, 0, nArray.length)) {
            ++n2;
        }
        return n2 > 0;
    }

    public boolean sendPixels(byte[] byArray, int n) {
        int n2 = this.source.setPixels(0, n, byArray.length, 1, Graycolormodel, byArray, 0, byArray.length);
        if (this.store.setPixels(0, n, byArray.length, 1, byArray, 0, byArray.length)) {
            ++n2;
        }
        return n2 > 0;
    }

    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readImage(this.input, new byte[1024]);
            this.store.imageComplete();
            if (this.store.getBitState() != 2) {
                this.source.setPixelStore(this.store);
            }
            this.source.imageComplete(3);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var2_1 = null;
        try {
            this.input.close();
        }
        catch (IOException iOException) {}
    }

    static {
        SecurityManager.enablePrivilege("UniversalLinkAccess");
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        System.loadLibrary(System.getProperty("netscape.jpw.dll", "jpw"));
        SecurityManager.revertPrivilege();
        RGBcolormodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        byte[] byArray = new byte[256];
        int n = 0;
        while (n < 256) {
            byArray[n] = (byte)n;
            ++n;
        }
        Graycolormodel = new IndexColorModel(8, 256, byArray, byArray, byArray);
    }
}

