/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import netscape.softupdate.InstallObject;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.WinReg;
import netscape.softupdate.WinRegValue;

final class WinRegItem
extends InstallObject {
    private WinReg reg;
    private int rootkey;
    private int command;
    private String subkey;
    private String name;
    private Object value;

    WinRegItem(WinReg winReg, int n, int n2, String string, String string2, Object object) throws SoftUpdateException {
        super(winReg.softUpdate());
        this.reg = winReg;
        this.command = n2;
        this.rootkey = n;
        this.subkey = string;
        this.name = string2;
        this.value = object;
    }

    protected void Complete() throws SoftUpdateException {
        switch (this.command) {
            case 1: {
                this.reg.finalCreateKey(this.rootkey, this.subkey, this.name);
                return;
            }
            case 2: {
                this.reg.finalDeleteKey(this.rootkey, this.subkey);
                return;
            }
            case 3: {
                this.reg.finalDeleteValue(this.rootkey, this.subkey, this.name);
                return;
            }
            case 4: {
                this.reg.finalSetValueString(this.rootkey, this.subkey, this.name, (String)this.value);
                return;
            }
            case 5: {
                this.reg.finalSetValue(this.rootkey, this.subkey, this.name, (WinRegValue)this.value);
                return;
            }
        }
        throw new SoftUpdateException("WinRegItem", -208);
    }

    float GetInstallOrder() {
        return 3.0f;
    }

    public String toString() {
        switch (this.command) {
            case 1: {
                return "Create Registry Key " + this.keystr(this.rootkey, this.subkey, null);
            }
            case 2: {
                return "Delete Registry key " + this.keystr(this.rootkey, this.subkey, null);
            }
            case 3: {
                return "Delete Registry value " + this.keystr(this.rootkey, this.subkey, this.name);
            }
            case 4: {
                return "Store Registry value " + this.keystr(this.rootkey, this.subkey, this.name);
            }
            case 5: {
                return "Store Registry value " + this.keystr(this.rootkey, this.subkey, this.name);
            }
        }
        return "Unknown " + this.keystr(this.rootkey, this.subkey, this.name);
    }

    private String keystr(int n, String string, String string2) {
        String string3;
        switch (n) {
            case -2147483648: {
                string3 = "\\HKEY_CLASSES_ROOT\\";
                break;
            }
            case -2147483647: {
                string3 = "\\HKEY_CURRENT_USER\\";
                break;
            }
            case -2147483646: {
                string3 = "\\HKEY_LOCAL_MACHINE\\";
                break;
            }
            case -2147483645: {
                string3 = "\\HKEY_USERS\\";
                break;
            }
            default: {
                string3 = "\\#" + n + "\\";
            }
        }
        if (string2 == null) {
            return String.valueOf(string3) + string;
        }
        return String.valueOf(string3) + string + " [" + string2 + "]";
    }
}

